/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.model;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.debug.core.RubyDebugModel;
import com.aptana.ruby.internal.debug.core.RubyDebuggerProxy;
import com.aptana.ruby.internal.debug.core.SuspensionPoint;
import com.aptana.ruby.internal.debug.core.model.IRubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyDebugElement;
import com.aptana.ruby.internal.debug.core.model.RubyThread;
import com.aptana.ruby.internal.debug.core.model.ThreadInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public class RubyDebugTarget
extends RubyDebugElement
implements IRubyDebugTarget {
    public static int DEFAULT_PORT = 1098;
    private IProcess process;
    private boolean isTerminated;
    private ILaunch launch;
    private RubyThread[] threads;
    private RubyDebuggerProxy rubyDebuggerProxy;
    private int port;
    private File debugParameterFile;
    private ArrayList<IBreakpoint> fBreakPoints;
    private String host;

    private RubyDebugTarget(ILaunch launch, IProcess process, String host, int port) {
        super(null);
        this.launch = launch;
        this.host = host;
        this.port = port;
        this.process = process;
        this.threads = new RubyThread[0];
        this.fBreakPoints = new ArrayList(5);
        this.isTerminated = false;
        if (DebugPlugin.getDefault() != null) {
            this.initializeBreakpoints();
        }
        this.addDebugParameter("$RemoteDebugPort=" + port);
    }

    public RubyDebugTarget(ILaunch launch, String host, int port) {
        this(launch, null, host, port);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void updateThreads() {
        RubyDebugCorePlugin.debug("udpating threads");
        ThreadInfo[] threadInfos = this.getRubyDebuggerProxy().readThreads();
        this.updateThreads(threadInfos);
    }

    public synchronized void updateThreads(ThreadInfo[] threadInfos) {
        if (this.isSuspended()) {
            return;
        }
        DebugEvent[] events = this.updateThreadsInternal(threadInfos);
        DebugPlugin.getDefault().fireDebugEventSet(events);
    }

    public DebugEvent[] updateThreadsInternal(ThreadInfo[] threadInfos) {
        ArrayList<DebugEvent> events = new ArrayList<DebugEvent>();
        RubyThread[] newThreads = new RubyThread[threadInfos.length];
        TreeSet<Integer> newIds = new TreeSet<Integer>();
        boolean changed = false;
        int i = 0;
        while (i < threadInfos.length) {
            DebugEvent ev;
            ThreadInfo currentThreadInfo = threadInfos[i];
            RubyThread existingThread = this.getThreadById(currentThreadInfo.getId());
            if (existingThread == null) {
                newThreads[i] = new RubyThread(this, currentThreadInfo.getId(), currentThreadInfo.getStatus());
                ev = new DebugEvent((Object)newThreads[i], 4);
                events.add(ev);
            } else {
                newThreads[i] = existingThread;
                if (!existingThread.getStatus().equals(currentThreadInfo.getStatus())) {
                    existingThread.setStatus(currentThreadInfo.getStatus());
                    existingThread.updateName();
                    ev = new DebugEvent((Object)newThreads[i], 16);
                    events.add(ev);
                }
            }
            newIds.add(newThreads[i].getId());
            ++i;
        }
        i = 0;
        while (i < this.threads.length) {
            if (!newIds.contains(this.threads[i].getId())) {
                DebugEvent ev = new DebugEvent((Object)this.threads[i], 8);
                events.add(ev);
            }
            ++i;
        }
        this.threads = newThreads;
        if (changed) {
            DebugEvent ev1 = new DebugEvent((Object)this, 16, 512);
            events.add(ev1);
        }
        return events.toArray(new DebugEvent[0]);
    }

    public RubyThread getThreadById(int id) {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i].getId() == id) {
                return this.threads[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void suspensionOccurred(SuspensionPoint suspensionPoint) {
        this.updateThreads();
        RubyThread thread = this.getThreadById(suspensionPoint.getThreadId());
        if (thread == null) {
            RubyDebugCorePlugin.log(4, MessageFormat.format("Thread with id {0} was not found", suspensionPoint.getThreadId()));
            return;
        }
        thread.doSuspend(suspensionPoint);
    }

    public IThread[] getThreads() {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.threads.length > 0;
    }

    public String getName() throws DebugException {
        return "Ruby";
    }

    public boolean supportsBreakpoint(IBreakpoint arg0) {
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public synchronized void terminate() throws DebugException {
        boolean deleted;
        if (this.isTerminated) {
            return;
        }
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.removeBreakpointListener((IBreakpointListener)this);
        try {
            this.rubyDebuggerProxy.stop();
            if (this.getProcess() != null) {
                this.getProcess().terminate();
            }
            this.threads = new RubyThread[0];
            this.isTerminated = true;
        }
        catch (DebugException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "com.aptana.ruby.debug.core", 5013, "Failed to stop ruby debugger proxy", (Throwable)e));
        }
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        if (this.debugParameterFile.exists() && !(deleted = this.debugParameterFile.delete())) {
            RubyDebugCorePlugin.debug("Could not delete debugParameterFile:" + this.debugParameterFile.toURI());
        }
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        boolean isSuspended = false;
        int i = 0;
        while (i < this.getThreads().length) {
            if (this.getThreads()[i].isSuspended()) {
                isSuspended = true;
                break;
            }
            ++i;
        }
        return isSuspended;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.isTerminated) {
            return;
        }
        if (!this.getBreakpoints().contains(breakpoint)) {
            if (this.getRubyDebuggerProxy() != null) {
                this.getRubyDebuggerProxy().addBreakpoint(breakpoint);
            }
            this.getBreakpoints().add(breakpoint);
        }
    }

    private List<IBreakpoint> getBreakpoints() {
        return this.fBreakPoints;
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta arg1) {
        if (this.isTerminated) {
            return;
        }
        this.getRubyDebuggerProxy().removeBreakpoint(breakpoint);
        this.fBreakPoints.remove(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta arg1) {
        if (this.isTerminated) {
            return;
        }
        this.getRubyDebuggerProxy().updateBreakpoint(breakpoint, arg1);
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long arg0, long arg1) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess process) {
        this.process = process;
    }

    @Override
    public RubyDebuggerProxy getRubyDebuggerProxy() {
        return this.rubyDebuggerProxy;
    }

    @Override
    public void setRubyDebuggerProxy(RubyDebuggerProxy rubyDebuggerProxy) {
        this.rubyDebuggerProxy = rubyDebuggerProxy;
    }

    public File getDebugParameterFile() {
        if (this.debugParameterFile == null) {
            try {
                this.debugParameterFile = File.createTempFile("classic-debug", ".rb");
            }
            catch (IOException e) {
                RubyDebugCorePlugin.log("Could not create debugParameterFile", e);
            }
        }
        return this.debugParameterFile;
    }

    protected void initializeBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] bps = manager.getBreakpoints(RubyDebugModel.getModelIdentifier());
        int i = 0;
        while (i < bps.length) {
            if (bps[i].getModelIdentifier().equals(RubyDebugModel.getModelIdentifier())) {
                this.breakpointAdded(bps[i]);
            }
            ++i;
        }
    }

    private boolean addDebugParameter(String line) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(this.getDebugParameterFile()));
            writer.println(line);
            writer.flush();
            return true;
        }
        catch (IOException ex) {
            RubyDebugCorePlugin.log(ex);
            return false;
        }
        finally {
            writer.close();
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean isUsingDefaultPort() {
        return this.getPort() == DEFAULT_PORT;
    }

    @Override
    public IStatus load(String filename) {
        return this.getRubyDebuggerProxy().readLoadResult(filename);
    }
}

